package univ.lille1;

import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

import android.app.Activity;
import android.os.Bundle;
import android.widget.TextView;

/**
 * Activity de la page detail
 * 
 * @author pahouayang
 *
 */
public class UserDetails extends Activity {

	TextView userDetail_textView1;
	TextView userDetail_textView2;
	TextView userDetail_textView3;
	TextView userDetail_textView4;
	TextView userDetail_textView5;

	@Override
	protected void onCreate(Bundle savedInstanceState) {
		super.onCreate(savedInstanceState);
		setContentView(R.layout.extbdduserdetail);

		// recupere le json envoyer precedement
		Bundle b = getIntent().getExtras();
		String pers = b.getString("personne");
		JSONObject personne;
		try {

			// recupere la personne qu'on a selectionne
			personne = new JSONObject(pers);

			// appel des textviex a modifier
			userDetail_textView1 = (TextView) findViewById(R.id.userDetail_textView1);
			userDetail_textView2 = (TextView) findViewById(R.id.userDetail_textView2);
			userDetail_textView3 = (TextView) findViewById(R.id.userDetail_textView3);
			userDetail_textView4 = (TextView) findViewById(R.id.userDetail_textView4);
			userDetail_textView5 = (TextView) findViewById(R.id.userDetail_textView5);

			// modification des textviews avec les infos de la personne
			userDetail_textView1.setText("Id : " + personne.getString("id"));
			userDetail_textView2.setText("Firstname : "
					+ personne.getString("firstname"));
			userDetail_textView3
					.setText("Name : " + personne.getString("name"));
			userDetail_textView4.setText("Age : " + personne.getString("age"));

			// recuperation des infomations de l'adresse de la personne : c'est
			// une array
			JSONArray adresse = personne.getJSONArray("address");
			// recureration de chacun des obj de l'adresse
			JSONObject number = (JSONObject) adresse.getJSONObject(0);
			JSONObject way = (JSONObject) adresse.getJSONObject(1);
			JSONObject code = (JSONObject) adresse.getJSONObject(2);
			JSONObject town = (JSONObject) adresse.getJSONObject(3);

			// modification du textview de l'adresse
			userDetail_textView5.setText("Address : "
					+ number.getString("number") + " " + way.getString("way")
					+ " " + code.getString("code") + " "
					+ town.getString("town"));

		} catch (JSONException e) {
			e.printStackTrace();
		}

	}

	@Override
	protected void onResume() {
		super.onResume();
	}

}