package univ.lille1;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.protocol.BasicHttpContext;
import org.apache.http.protocol.HttpContext;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

import android.app.Activity;
import android.content.Intent;
import android.os.AsyncTask;
import android.os.Bundle;
import android.view.View;
import android.widget.AdapterView;
import android.widget.AdapterView.OnItemClickListener;
import android.widget.Button;
import android.widget.ListAdapter;
import android.widget.ListView;
import android.widget.SimpleAdapter;

/**
 * Fonction GET : classe pour le get run danc un thread qui extends AsyncTack
 *
 * 
 * @author pahouayang
 *
 */
public class GetUsers extends AsyncTask<Void, Void, String> {

	public Activity activity;
	public ListView vue;

	public GetUsers(Activity activity) {
		this.activity = activity;
	}

	/**
	 * change l'entity recupere en ascii
	 * 
	 * @param entity
	 * @throws IllegalStateException
	 * @throws IOException
	 */
	protected String getASCIIContentFromEntity(HttpEntity entity)
			throws IllegalStateException, IOException {
		InputStream in = entity.getContent();
		StringBuffer out = new StringBuffer();
		int n = 1;
		while (n > 0) {
			byte[] b = new byte[4096];
			n = in.read(b);
			if (n > 0)
				out.append(new String(b, 0, n));
		}
		return out.toString();
	}

	/**
	 * utilisation du bundled http get de Apache pour recuperer les information
	 * de l'url et les met dans text
	 */
	protected String doInBackground(Void... params) {
		// url
		String uri = "http://pahoua-yang.fr/projets/android/personne.json";
		// nous sommes client
		HttpClient httpClient = new DefaultHttpClient();
		// notre context
		HttpContext localContext = new BasicHttpContext();
		// bundled http get de Apache
		HttpGet httpGet = new HttpGet(uri);
		String text = null;
		try {
			// reponce de la requete
			HttpResponse response = httpClient.execute(httpGet, localContext);
			// stok la reponse dans une entity
			HttpEntity entity = response.getEntity();
			// transforme l'entity en string
			text = getASCIIContentFromEntity(entity);
		} catch (Exception e) {
			return e.getLocalizedMessage();
		}
		return text;
	}

	/**
	 * apres le get, modification de la vue de la liste
	 */
	protected void onPostExecute(String results) {

		vue = (ListView) this.activity.findViewById(R.id.testPage_listView);

		final String res = results;
		JSONObject obj;
		JSONArray personnes = null;
		String[][] repertoire = null;

		try {
			// recuperation du json
			obj = new JSONObject(results);
			// recuperation de la liste de personne
			personnes = obj.getJSONArray("personnes");
			repertoire = new String[personnes.length()][2];

			// recuperation du nom et prénom de chacune des personnes
			for (int i = 0; i < personnes.length(); i++) {
				final JSONObject personne = personnes.getJSONObject(i);
				repertoire[i][0] = personne.getString("firstname");
				repertoire[i][1] = personne.getString("name");
			}

		} catch (JSONException e) {
			e.printStackTrace();
		}

		// transforme le tableau de string en hashmap
		List<HashMap<String, String>> liste = new ArrayList<HashMap<String, String>>();
		HashMap<String, String> element;
		for (int i = 0; i < repertoire.length; i++) {
			element = new HashMap<String, String>();
			element.put("donnee1", repertoire[i][0]);
			element.put("donnee2", repertoire[i][1]);
			liste.add(element);
		}

		// insertion de la hashmap dans un listadapter
		ListAdapter adapter = new SimpleAdapter(this.activity, liste,
				android.R.layout.simple_list_item_2, new String[] { "donnee1",
						"donnee2" }, new int[] { android.R.id.text1,
						android.R.id.text2 });

		// modification de la listview
		vue.setAdapter(adapter);

		// on reactive le bouton
		Button b = (Button) this.activity.findViewById(R.id.testPage_button);
		b.setClickable(true);

		// mise du onclick sur la liste
		ListView lv = (ListView) activity.findViewById(R.id.testPage_listView);
		lv.setOnItemClickListener(new OnItemClickListener() {
			public void onItemClick(AdapterView<?> parent, View view,
					int position, long id) {
				Intent intent = new Intent(activity, UserDetails.class);
				try {

					// on reprend le json
					JSONObject obj = new JSONObject(res);
					// on prend la liste de personnes
					JSONArray personnes = obj.getJSONArray("personnes");
					// on recupere la personne grace a l'indice de la ou on a
					// clique
					JSONObject personne = personnes.getJSONObject(position);

					// creation du bundle
					Bundle bundleObject = new Bundle();
					// on met l'objet dans le bundle
					bundleObject.putString("personne", personne.toString());
					// met le Bundle dans in intent : permet d'envoyer un json
					// d'une activity a une autre
					intent.putExtras(bundleObject);

					// start de l'activity de la page suivante
					activity.startActivity(intent);

				} catch (JSONException e) {
					e.printStackTrace();
				}
			}
		});
	}
}